// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtSAMIFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_SAMI_FILE_FORMAT_H
#define AVT_SAMI_FILE_FORMAT_H

#include <silo.h>

#include <avtSTSDFileFormat.h>

class vtkDataSet;
class vtkDataArray;
class avtMaterial;


// ****************************************************************************
//  Class: avtSAMIFileFormat
//
//  Purpose:
//      Reads in SAMI files as a plugin to VisIt.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Wed Oct 11 13:40:57 PST 2006
//
//  Modifications:
//
//    Mark C. Miller, Tue Nov 29 11:37:32 PST 2011
//    Added InitFile method.
// ****************************************************************************

class avtSAMIFileFormat : public avtSTSDFileFormat
{
  public:
                       avtSAMIFileFormat(const char *filename);
    virtual           ~avtSAMIFileFormat() {;};

    virtual const char    *GetType(void)   { return "SAMI"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);
    virtual avtMaterial   *GetMaterial(const char *);
    virtual void          *GetAuxiliaryData(const char *var,
                                            const char *type, void *args,
                                            DestructorFunction &);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

  private:
      void                 InitFile();
      DBfile              *dbFile;
      int nzones, nshells, nbeams, nnodes, nmats, nslides, iorigin, ndims;
      char *xVals, *yVals, *zVals;

};

#endif
