// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtPlainTextOptions.C                              //
// ************************************************************************* //

#include <avtPlainTextOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>


// ****************************************************************************
//  Function: GetPlainTextReadOptions
//
//  Purpose:
//      Creates the options for PlainText readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Thu Jan 24 10:45:23 PDT 2008
//
//  Modifications:
//    Jeremy Meredith, Fri Apr 30 09:57:29 EDT 2010
//    Changed data layout field to have a new default, and so I renamed
//    it so it wouldn't conflict with the old values.
//
// ****************************************************************************

DBOptionsAttributes *
GetPlainTextReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    std::vector<std::string> types;
    types.push_back("1D Columns");
    types.push_back("2D Array");
    rv->SetEnum("Data layout", 0);
    rv->SetEnumStrings("Data layout", types);

    rv->SetInt("Lines to skip at beginning of file", 0);

    rv->SetBool("First row has variable names", false);

    rv->SetInt("Column for X coordinate (or -1 for none)", -1);
    rv->SetInt("Column for Y coordinate (or -1 for none)", -1);
    rv->SetInt("Column for Z coordinate (or -1 for none)", -1);

    return rv;
}


// ****************************************************************************
//  Function: GetPlainTextWriteOptions
//
//  Purpose:
//      Creates the options for PlainText writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Thu Jan 24 10:45:23 PDT 2008
//
// ****************************************************************************

DBOptionsAttributes *
GetPlainTextWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
