// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PlainTextPluginInfo.C
// ****************************************************************************

#include <PlainTextPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(PlainText,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(PlainText,General)

// ****************************************************************************
//  Method: PlainTextGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PlainTextGeneralPluginInfo::GetName() const
{
    return "PlainText";
}

// ****************************************************************************
//  Method: PlainTextGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PlainTextGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: PlainTextGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PlainTextGeneralPluginInfo::GetID() const
{
    return "PlainText_1.0";
}
// ****************************************************************************
//  Method: PlainTextGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PlainTextGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: PlainTextGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PlainTextGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  PlainTextGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a PlainText database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
PlainTextGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.csv");
    defaultPatterns.push_back("*.tsv");
    defaultPatterns.push_back("*.txt");
    defaultPatterns.push_back("*.csv.gz");
    defaultPatterns.push_back("*.tsv.gz");
    defaultPatterns.push_back("*.txt.gz");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  PlainTextGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a PlainText database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
PlainTextGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  PlainTextGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the PlainText plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
PlainTextGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
