// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PVLDPluginInfo.C
// ****************************************************************************

#include <PVLDPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(PVLD,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(PVLD,General)

// ****************************************************************************
//  Method: PVLDGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PVLDGeneralPluginInfo::GetName() const
{
    return "PVLD";
}

// ****************************************************************************
//  Method: PVLDGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PVLDGeneralPluginInfo::GetVersion() const
{
    return "1";
}

// ****************************************************************************
//  Method: PVLDGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PVLDGeneralPluginInfo::GetID() const
{
    return "PVLD_1";
}
// ****************************************************************************
//  Method: PVLDGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PVLDGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: PVLDGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PVLDGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  PVLDGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a PVLD database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
PVLDGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.pvld");
    defaultPatterns.push_back("*.vld");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  PVLDGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a PVLD database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
PVLDGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  PVLDGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the PVLD plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
PVLDGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
