// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtPLYWriter.h                                //
// ************************************************************************* //

#ifndef AVT_PLY_WRITER_H
#define AVT_PLY_WRITER_H

#include <avtDatabaseWriter.h>

#include <string>

class DBOptionsAttributes;
class vtkPolyData;
class vtkScalarsToColors;

// ****************************************************************************
//  Class: avtPLYWriter
//
//  Purpose:
//      A module that writes out PLY files.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:57:58 PDT 2013
//
//  Modifications:
//   Dave Pugmire, Fri Apr 26 12:33:39 EDT 2013
//   Add color table options.
//
//   Brad Whitlock, Tue Sep  8 17:03:17 PDT 2015
//   Rely on base class for geometry aggregation.
//
// ****************************************************************************

class
avtPLYWriter : public avtDatabaseWriter
{
  public:
                   avtPLYWriter(DBOptionsAttributes *);
    virtual       ~avtPLYWriter() {}

  protected:
    std::string    stem;

    virtual void   OpenFile(const std::string &, int nb);
    virtual void   WriteHeaders(const avtDatabaseMetaData *,
                                const std::vector<std::string> &, 
                                const std::vector<std::string> &,
                                const std::vector<std::string> &);
    virtual void   WriteChunk(vtkDataSet *, int);
    virtual void   CloseFile(void);

    virtual bool          CreateTrianglePolyData() const;
    virtual CombineMode   GetCombineMode(const std::string &plotName) const;

  private:
    vtkScalarsToColors * GetColorTable();
    
    bool                       doBinary, doColor;
    std::string                colorTable;
    double                     colorTableMin, colorTableMax;
};


#endif
