// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtPLYFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_PLY_FILE_FORMAT_H
#define AVT_PLY_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>

class DBOptionsAttributes;

// ****************************************************************************
//  Class: avtPLYFileFormat
//
//  Purpose:
//      Reads in PLY files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:57:58 PDT 2013
//
// ****************************************************************************

class avtPLYFileFormat : public avtSTSDFileFormat
{
  public:
    avtPLYFileFormat(const char *filename, DBOptionsAttributes*&);
    virtual           ~avtPLYFileFormat();


    virtual const char    *GetType(void)   { return "PLY"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);

  protected:
    vtkDataSet           *dataset;
    bool                  readInDataset;
    bool                  checkedFile;
    void                  ReadInDataset(void);

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
};


#endif
