// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtPICS_TesterFileFormat.h                     //
// ************************************************************************* //

#ifndef AVT_PICS_Tester_FILE_FORMAT_H
#define AVT_PICS_Tester_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>


// ****************************************************************************
//  Class: avtPICS_TesterFileFormat
//
//  Purpose:
//      Reads in PICS_Tester files as a plugin to VisIt.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Tue Mar 6 07:45:19 PDT 2012
//
// ****************************************************************************

class avtPICS_TesterFileFormat : public avtMTMDFileFormat
{
  public:
                       avtPICS_TesterFileFormat(const char *);
    virtual           ~avtPICS_TesterFileFormat() {;};

    bool                  HasInvariantMetaData(void) const { return false; };
    bool                  HasInvariantSIL(void) const { return false; };

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    virtual void      *GetAuxiliaryData(const char *var, int timestep, 
                                        int domain, const char *type, void *args, 
                                        DestructorFunction &);

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    virtual void           GetTimes(std::vector<double> &t) { t = times; };

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "PICS_Tester"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    void                   ReadHeader(const char *);

    bool                   isRectilinear;
    int                    rank;
    std::vector<int>       numBlocks[3];
    std::vector<int>       numCells[3];
    std::vector<double>    times;
    std::vector<int>       cycles;
    std::vector<double>    vels;
    std::vector<double>    magnitudes;

    enum FlowType { UNKNOWN,
                    STANDARD,
                    DOUBLE_GYRE,
                    ABC_FLOW_STEADY_STATE,
                    ABC_FLOW_APERIODIC };

    FlowType flowType;

    double global_extents[3];

    // Double gyre flow constants
    double dg_A;
    double dg_epsilon;
    double dg_period;

    // ABC flow constants
    double abc_c0;
    double abc_c1;
    double abc_c2;

    int abc_signalA;
    int abc_signalB;
    int abc_signalC;
};

#endif
