// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtPDBOptions.C                               //
// ************************************************************************* //

#include <avtPDBOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;


// ****************************************************************************
//  Function: GetPDBReadOptions
//
//  Purpose:
//      Creates the options for PDB readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by hand 
//  Creation:   April 29, 2008 
//
// ****************************************************************************

DBOptionsAttributes *
GetPDBReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetInt("LEOS try harder level [set to 0, 1 or 2]", 0);
    return rv;
}


// ****************************************************************************
//  Function: GetPDBWriteOptions
//
//  Purpose:
//      Creates the options for PDB writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by hand 
//  Creation:   April 29, 2008 
//
// ****************************************************************************

DBOptionsAttributes *
GetPDBWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
