// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtNektarPPOptions.h                          //
// ************************************************************************* //

#ifndef AVT_NektarPP_OPTIONS_H
#define AVT_NektarPP_OPTIONS_H

#include <string>

class DBOptionsAttributes;

namespace NektarPPDBOptions
{
    // Read options
    const char *const NEKTARPP_MESH_REFINEMENT = "Mesh refinement";
    const char *const NEKTARPP_ASSUME_PLANAR_ELEMENTS = "Assume planar elements";
}

// ****************************************************************************
//  Functions: avtNektarPPOptions
//
//  Purpose:
//      Creates the options for  NektarPP readers and/or writers.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Nov 7 13:51:33 PST 2014
//
// ****************************************************************************

DBOptionsAttributes *GetNektarPPReadOptions(void);
DBOptionsAttributes *GetNektarPPWriteOptions(void);


#endif
