// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtNektarPPOptions.C                          //
// ************************************************************************* //

#include <avtNektarPPOptions.h>

#include <DBOptionsAttributes.h>

using namespace NektarPPDBOptions;

// ****************************************************************************
//  Function: GetNektarPPReadOptions
//
//  Purpose:
//      Creates the options for NektarPP readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Nov 7 13:51:33 PST 2014
//
// ****************************************************************************

DBOptionsAttributes *
GetNektarPPReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    rv->SetEnum(NEKTARPP_MESH_REFINEMENT, 0);
    std::vector<std::string> refinement;
    refinement.push_back("auto");
    refinement.push_back("1");
    refinement.push_back("2");
    refinement.push_back("3");
    refinement.push_back("4");
    refinement.push_back("5");
    refinement.push_back("6");
    refinement.push_back("7");
    refinement.push_back("8");
    refinement.push_back("9");
    refinement.push_back("10");
    rv->SetEnumStrings(NEKTARPP_MESH_REFINEMENT, refinement);

    rv->SetBool(NEKTARPP_ASSUME_PLANAR_ELEMENTS, true);

    return rv;
}


// ****************************************************************************
//  Function: GetNektarPPWriteOptions
//
//  Purpose:
//      Creates the options for NektarPP writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Nov 7 13:51:33 PST 2014
//
// ****************************************************************************

DBOptionsAttributes *
GetNektarPPWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
