// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: NETCDFPluginInfo.C
// ****************************************************************************

#include <NETCDFPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(NETCDF,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(NETCDF,General)

// ****************************************************************************
//  Method: NETCDFGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NETCDFGeneralPluginInfo::GetName() const
{
    return "NETCDF";
}

// ****************************************************************************
//  Method: NETCDFGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NETCDFGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: NETCDFGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NETCDFGeneralPluginInfo::GetID() const
{
    return "NETCDF_1.0";
}
// ****************************************************************************
//  Method: NETCDFGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
NETCDFGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: NETCDFGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
NETCDFGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  NETCDFGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a NETCDF database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
NETCDFGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.nc");
    defaultPatterns.push_back("*.cdf");
    defaultPatterns.push_back("*.elev");
    defaultPatterns.push_back("*.ncd");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  NETCDFGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a NETCDF database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
NETCDFGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  NETCDFGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the NETCDF plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
NETCDFGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
