// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MatrixMarketPluginInfo.C
// ****************************************************************************

#include <MatrixMarketPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(MatrixMarket,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(MatrixMarket,General)

// ****************************************************************************
//  Method: MatrixMarketGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MatrixMarketGeneralPluginInfo::GetName() const
{
    return "MatrixMarket";
}

// ****************************************************************************
//  Method: MatrixMarketGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MatrixMarketGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: MatrixMarketGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MatrixMarketGeneralPluginInfo::GetID() const
{
    return "MatrixMarket_1.0";
}
// ****************************************************************************
//  Method: MatrixMarketGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
MatrixMarketGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: MatrixMarketGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
MatrixMarketGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  MatrixMarketGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a MatrixMarket database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
MatrixMarketGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.mpippv");
    defaultPatterns.push_back("*.mpippc");
    defaultPatterns.push_back("*.mtx");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  MatrixMarketGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a MatrixMarket database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
MatrixMarketGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  MatrixMarketGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the MatrixMarket plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
MatrixMarketGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
