// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtMOABOptions.C                              //
// ************************************************************************* //

#include <avtMOABOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>


// ****************************************************************************
//  Function: GetMOABReadOptions
//
//  Purpose:
//      Creates the options for MOAB readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

DBOptionsAttributes *
GetMOABReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Parallel format", true);
    rv->SetEnum("Dimension", 1);
    std::vector<std::string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetString("Partition:", "PARALLEL_PARTITION" );
    return rv;
/* EXAMPLE OF OPTIONS
    rv->SetBool("Big Endian", false);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
}


// ****************************************************************************
//  Function: GetMOABWriteOptions
//
//  Purpose:
//      Creates the options for MOAB writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

DBOptionsAttributes *
GetMOABWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
