// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LAMMPSPluginInfo.C
// ****************************************************************************

#include <LAMMPSPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(LAMMPS,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(LAMMPS,General)

// ****************************************************************************
//  Method: LAMMPSGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LAMMPSGeneralPluginInfo::GetName() const
{
    return "LAMMPS";
}

// ****************************************************************************
//  Method: LAMMPSGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LAMMPSGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: LAMMPSGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LAMMPSGeneralPluginInfo::GetID() const
{
    return "LAMMPS_1.0";
}
// ****************************************************************************
//  Method: LAMMPSGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
LAMMPSGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: LAMMPSGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
LAMMPSGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  LAMMPSGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a LAMMPS database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
LAMMPSGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.eam");
    defaultPatterns.push_back("*.meam");
    defaultPatterns.push_back("*.rigid");
    defaultPatterns.push_back("*.dump");
    defaultPatterns.push_back("*.lammps");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  LAMMPSGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a LAMMPS database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
LAMMPSGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  LAMMPSGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the LAMMPS plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
LAMMPSGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
