// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <LAMMPSPluginInfo.h>
#include <avtLAMMPSFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  LAMMPSCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a LAMMPS database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
LAMMPSCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method: LAMMPSCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a LAMMPS database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A LAMMPS database from list.
//
//  Programmer: Jeremy Meredith
//  Creation:   February  9, 2009
//
// ****************************************************************************

avtDatabase *
LAMMPSCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtDatabase *db = 0;

    //
    // Create a file format interface.
    //
    avtFileFormatInterface *ffi = LAMMPS_CreateFileFormatInterface(list,
                                                                   nList,
                                                                   nBlock);

    //
    // If we created a file format interface, try creating a database.
    //
    if(ffi)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(ffi);
        }
        CATCH(VisItException)
        {
            delete ffi;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;
}

