// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: KullLitePluginInfo.C
// ****************************************************************************

#include <KullLitePluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(KullLite,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(KullLite,General)

// ****************************************************************************
//  Method: KullLiteGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
KullLiteGeneralPluginInfo::GetName() const
{
    return "KullLite";
}

// ****************************************************************************
//  Method: KullLiteGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
KullLiteGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: KullLiteGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
KullLiteGeneralPluginInfo::GetID() const
{
    return "KullLite_1.0";
}
// ****************************************************************************
//  Method: KullLiteGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
KullLiteGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: KullLiteGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
KullLiteGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  KullLiteGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a KullLite database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
KullLiteGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.pdb");
    defaultPatterns.push_back("*.mkf");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  KullLiteGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a KullLite database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
KullLiteGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  KullLiteGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the KullLite plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
KullLiteGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
