// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtIDXFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_IDX_FILE_FORMAT_H
#define AVT_IDX_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>
#include <DBOptionsAttributes.h>
#include <visit_idx_io.h>
#include <string>
#include <LevelInfo.h>
#include <vtkXMLDataElement.h>

#ifdef USE_VISUS
  #include <visus_idx_io.h>
#else
  #include <pidx_idx_io.h>
#endif

typedef std::string String;

// ****************************************************************************
//  Class: avtIDXFileFormat
//
//  Purpose:
//      Reads in IDX files as a plugin to VisIt.
//
//  Programmer: spetruzza, camc -- generated by xml2avt
//  Creation:   Tue Jan 7 12:20:07 MST 2014
//
// ****************************************************************************

struct gidx_info{
    String url;
    int log_time;
};

class avtIDXFileFormat : public avtMTMDFileFormat
{
  public:
                       avtIDXFileFormat(const char *, DBOptionsAttributes* attrs);
    virtual           ~avtIDXFileFormat();

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep, 
    //                                     int domain, const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "IDX"; };

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    //virtual vtkDataArray  *GetVar(int timestate, const char *varname);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

    virtual void           GetCycles(std::vector<int> &);
    virtual void           GetTimes(std::vector<double> &);
    
    virtual void           FreeUpResources(void);
    virtual void           ActivateTimestep(int ts);

    virtual bool     HasInvariantMetaData(void) const { return false; };
    virtual bool     HasInvariantSIL(void) const { return false; };

    virtual void     *GetAuxiliaryData(const char *var, int,
                                     const char *type, void *args,
                                     DestructorFunction &){ return NULL; }

  protected:

    std::string                   dataset_filename;
    std::string                   metadata_filename;
    int                           nprocs;
    int                           rank;
    int                           dim;         //2d or 3d

    bool use_extracells;
    bool is_gidx;
    int sfc_offset[3];
    std::vector<gidx_info> gidx_datasets;
    bool uintah_metadata;

  private:

    PIDXIO* reader;
    bool reverse_endian;
    std::map<std::string, void_ref_ptr> mesh_boundaries;
    std::map<std::string, void_ref_ptr> mesh_domains;

    std::string grid_type;
    std::string mesh_name;

    LevelInfo level_info;

    LevelInfo input_patches;

    std::vector<double> timeIndex;
    std::vector<int> logTimeIndex;

    vtkDataArray* queryToVtk(int timestate, int domain, const char *varname);

    void createBoxes();
    void createTimeIndex();
    void computeDomainBoundaries(const char* meshname, int timestate);
    void SetUpDomainConnectivity(const char* meshname);

    void domainDecomposition();


};


#endif
