// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: H5PartPluginInfo.C
// ****************************************************************************

#include <H5PartPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(H5Part,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(H5Part,General)

// ****************************************************************************
//  Method: H5PartGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
H5PartGeneralPluginInfo::GetName() const
{
    return "H5Part";
}

// ****************************************************************************
//  Method: H5PartGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
H5PartGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: H5PartGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
H5PartGeneralPluginInfo::GetID() const
{
    return "H5Part_1.0";
}
// ****************************************************************************
//  Method: H5PartGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
H5PartGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: H5PartGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
H5PartGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  H5PartGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a H5Part database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
H5PartGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.h5part");
    defaultPatterns.push_back("*.h5");
    defaultPatterns.push_back("*.h5p");
    defaultPatterns.push_back("*.h5block");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  H5PartGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a H5Part database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
H5PartGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  H5PartGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the H5Part plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
H5PartGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
