// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: H5NimrodPluginInfo.C
// ****************************************************************************

#include <H5NimrodPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(H5Nimrod,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(H5Nimrod,General)

// ****************************************************************************
//  Method: H5NimrodGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
H5NimrodGeneralPluginInfo::GetName() const
{
    return "H5Nimrod";
}

// ****************************************************************************
//  Method: H5NimrodGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
H5NimrodGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: H5NimrodGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
H5NimrodGeneralPluginInfo::GetID() const
{
    return "H5Nimrod_1.0";
}
// ****************************************************************************
//  Method: H5NimrodGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
H5NimrodGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: H5NimrodGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
H5NimrodGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  H5NimrodGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a H5Nimrod database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
H5NimrodGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.h5");
    defaultPatterns.push_back("*.h5nimrod");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  H5NimrodGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a H5Nimrod database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
H5NimrodGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  H5NimrodGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the H5Nimrod plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
H5NimrodGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
