// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: GeqdskPluginInfo.C
// ****************************************************************************

#include <GeqdskPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Geqdsk,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Geqdsk,General)

// ****************************************************************************
//  Method: GeqdskGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
GeqdskGeneralPluginInfo::GetName() const
{
    return "Geqdsk";
}

// ****************************************************************************
//  Method: GeqdskGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
GeqdskGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: GeqdskGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
GeqdskGeneralPluginInfo::GetID() const
{
    return "Geqdsk_1.0";
}
// ****************************************************************************
//  Method: GeqdskGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
GeqdskGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: GeqdskGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
GeqdskGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  GeqdskGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Geqdsk database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
GeqdskGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.geq");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  GeqdskGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Geqdsk database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
GeqdskGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  GeqdskGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Geqdsk plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
GeqdskGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
