// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: GDALPluginInfo.C
// ****************************************************************************

#include <GDALPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(GDAL,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(GDAL,General)

// ****************************************************************************
//  Method: GDALGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
GDALGeneralPluginInfo::GetName() const
{
    return "GDAL";
}

// ****************************************************************************
//  Method: GDALGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
GDALGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: GDALGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
GDALGeneralPluginInfo::GetID() const
{
    return "GDAL_1.0";
}
// ****************************************************************************
//  Method: GDALGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
GDALGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: GDALGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
GDALGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  GDALGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a GDAL database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
GDALGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.adf");
    defaultPatterns.push_back("*.asc");
    defaultPatterns.push_back("*.bt");
    defaultPatterns.push_back("*.ddf");
    defaultPatterns.push_back("*.dem");
    defaultPatterns.push_back("*.ecw");
    defaultPatterns.push_back("*.gxf");
    defaultPatterns.push_back("*.jp2");
    defaultPatterns.push_back("*.map");
    defaultPatterns.push_back("*.mem");
    defaultPatterns.push_back("*.mpl");
    defaultPatterns.push_back("*.mpr");
    defaultPatterns.push_back("*.n1");
    defaultPatterns.push_back("*.nat");
    defaultPatterns.push_back("*.ntf");
    defaultPatterns.push_back("*.pix");
    defaultPatterns.push_back("*.rsw");
    defaultPatterns.push_back("*.sid");
    defaultPatterns.push_back("*.vrt");
    defaultPatterns.push_back("*.xpm");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  GDALGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a GDAL database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
GDALGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  GDALGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the GDAL plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
GDALGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
