// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <FieldViewXDBPluginInfo.h>
#include <avtFieldViewXDBFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtFieldViewXDBOptions.h>

// ****************************************************************************
//  Method:  FieldViewXDBCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a FieldViewXDB database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
FieldViewXDBCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: FieldViewXDBCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a FieldViewXDB database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A FieldViewXDB database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
FieldViewXDBCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    // ignore any nBlocks past 1
    int nTimestepGroups = nList / nBlock;
    avtMTMDFileFormat **ffl = new avtMTMDFileFormat*[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtFieldViewXDBFileFormat(list[i*nBlock], readOptions);
    }
    avtMTMDFileFormatInterface *inter
           = new avtMTMDFileFormatInterface(ffl, nTimestepGroups);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: FieldViewXDBCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
FieldViewXDBCommonPluginInfo::GetReadOptions() const
{
    return GetFieldViewXDBReadOptions();
}

// ****************************************************************************
//  Method: FieldViewXDBCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
FieldViewXDBCommonPluginInfo::GetWriteOptions() const
{
    return GetFieldViewXDBWriteOptions();
}


// ****************************************************************************
//  Method: FieldViewXDBCommonPluginInfo::GetLicense
//
//  Purpose: Get the copyright for the library.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Apr  8 16:07:39 PDT 2014
//
// ****************************************************************************
#include <avtFieldViewXDBWriterInternal.h>

std::string
FieldViewXDBCommonPluginInfo::GetLicense() const
{
    return avtFieldViewXDBWriterInternal::GetCopyright();
}

