// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExodusPluginInfo.C
// ****************************************************************************

#include <ExodusPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Exodus,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Exodus,General)

// ****************************************************************************
//  Method: ExodusGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExodusGeneralPluginInfo::GetName() const
{
    return "Exodus";
}

// ****************************************************************************
//  Method: ExodusGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExodusGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ExodusGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExodusGeneralPluginInfo::GetID() const
{
    return "Exodus_1.0";
}
// ****************************************************************************
//  Method: ExodusGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ExodusGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ExodusGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ExodusGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  ExodusGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Exodus database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ExodusGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.ex");
    defaultPatterns.push_back("*.e");
    defaultPatterns.push_back("*.exo");
    defaultPatterns.push_back("*.ex2");
    defaultPatterns.push_back("*.exii");
    defaultPatterns.push_back("*.exoii");
    defaultPatterns.push_back("*.e.#.#");
    defaultPatterns.push_back("*.e.##.##");
    defaultPatterns.push_back("*.e.###.###");
    defaultPatterns.push_back("*.e.####.####");
    defaultPatterns.push_back("*.e.#####.#####");
    defaultPatterns.push_back("*.ex.#.#");
    defaultPatterns.push_back("*.ex.##.##");
    defaultPatterns.push_back("*.ex.###.###");
    defaultPatterns.push_back("*.ex.####.####");
    defaultPatterns.push_back("*.ex.#####.#####");
    defaultPatterns.push_back("*.exo.#.#");
    defaultPatterns.push_back("*.exo.##.##");
    defaultPatterns.push_back("*.exo.###.###");
    defaultPatterns.push_back("*.exo.####.####");
    defaultPatterns.push_back("*.exo.#####.#####");
    defaultPatterns.push_back("*.ex2.#.#");
    defaultPatterns.push_back("*.ex2.##.##");
    defaultPatterns.push_back("*.ex2.###.###");
    defaultPatterns.push_back("*.ex2.####.####");
    defaultPatterns.push_back("*.ex2.#####.#####");
    defaultPatterns.push_back("*.exii.#.#");
    defaultPatterns.push_back("*.exii.##.##");
    defaultPatterns.push_back("*.exii.###.###");
    defaultPatterns.push_back("*.exii.####.####");
    defaultPatterns.push_back("*.exii.#####.#####");
    defaultPatterns.push_back("*.gen");
    defaultPatterns.push_back("*.exodus");
    defaultPatterns.push_back("*.nemesis");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ExodusGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Exodus database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ExodusGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ExodusGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Exodus plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ExodusGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
