// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EnzoPluginInfo.C
// ****************************************************************************

#include <EnzoPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Enzo,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Enzo,General)

// ****************************************************************************
//  Method: EnzoGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EnzoGeneralPluginInfo::GetName() const
{
    return "Enzo";
}

// ****************************************************************************
//  Method: EnzoGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EnzoGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: EnzoGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EnzoGeneralPluginInfo::GetID() const
{
    return "Enzo_1.0";
}
// ****************************************************************************
//  Method: EnzoGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
EnzoGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: EnzoGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
EnzoGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  EnzoGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Enzo database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
EnzoGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.hierarchy");
    defaultPatterns.push_back("*.boundary");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  EnzoGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Enzo database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
EnzoGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  EnzoGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Enzo plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
EnzoGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
