// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: Dyna3DPluginInfo.C
// ****************************************************************************

#include <Dyna3DPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Dyna3D,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Dyna3D,General)

// ****************************************************************************
//  Method: Dyna3DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Dyna3DGeneralPluginInfo::GetName() const
{
    return "Dyna3D";
}

// ****************************************************************************
//  Method: Dyna3DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Dyna3DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: Dyna3DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Dyna3DGeneralPluginInfo::GetID() const
{
    return "Dyna3D_1.0";
}
// ****************************************************************************
//  Method: Dyna3DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Dyna3DGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: Dyna3DGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Dyna3DGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  Dyna3DGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Dyna3D database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
Dyna3DGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.dyn");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  Dyna3DGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Dyna3D database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Dyna3DGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  Dyna3DGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Dyna3D plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Dyna3DGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
