// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DDCMDPluginInfo.C
// ****************************************************************************

#include <DDCMDPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(DDCMD,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(DDCMD,General)

// ****************************************************************************
//  Method: DDCMDGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DDCMDGeneralPluginInfo::GetName() const
{
    return "DDCMD";
}

// ****************************************************************************
//  Method: DDCMDGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DDCMDGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: DDCMDGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DDCMDGeneralPluginInfo::GetID() const
{
    return "DDCMD_1.0";
}
// ****************************************************************************
//  Method: DDCMDGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
DDCMDGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: DDCMDGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
DDCMDGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  DDCMDGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a DDCMD database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
DDCMDGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.ddcmd");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  DDCMDGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a DDCMD database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
DDCMDGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  DDCMDGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the DDCMD plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
DDCMDGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
