// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <CarpetHDF5PluginInfo.h>
#include <avtCarpetHDF5FileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  CarpetHDF5CommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a CarpetHDF5 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
CarpetHDF5CommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: CarpetHDF5CommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a CarpetHDF5 database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A CarpetHDF5 database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
CarpetHDF5CommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    // ignore any nBlocks past 1
    // NOTE from Christian Reisswig:
    //    Visit tries to be smart with grouping files together.
    //    This feature is switched on by default in the file selector menu.
    //    The effect is that Visit tries to open all bla.file_*.h5 files
    //    and treats them as different timesteps!
    //    To avoid this, we only open the first file by setting
    //    nTimestepGroups = 1.
    int nTimestepGroups = 1; //nList / nBlock;
    avtMTMDFileFormat **ffl = new avtMTMDFileFormat*[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtCarpetHDF5FileFormat(list[i*nBlock]);
    }
    avtMTMDFileFormatInterface *inter
           = new avtMTMDFileFormatInterface(ffl, nTimestepGroups);
    return new avtGenericDatabase(inter);
}

