// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CaleHDF5PluginInfo.C
// ****************************************************************************

#include <CaleHDF5PluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(CaleHDF5,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(CaleHDF5,General)

// ****************************************************************************
//  Method: CaleHDF5GeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CaleHDF5GeneralPluginInfo::GetName() const
{
    return "CaleHDF5";
}

// ****************************************************************************
//  Method: CaleHDF5GeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CaleHDF5GeneralPluginInfo::GetVersion() const
{
    return "1.1";
}

// ****************************************************************************
//  Method: CaleHDF5GeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CaleHDF5GeneralPluginInfo::GetID() const
{
    return "CaleHDF5_1.1";
}
// ****************************************************************************
//  Method: CaleHDF5GeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CaleHDF5GeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: CaleHDF5GeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CaleHDF5GeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  CaleHDF5GeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a CaleHDF5 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
CaleHDF5GeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.ch5");
    defaultPatterns.push_back("*.cale");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  CaleHDF5GeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a CaleHDF5 database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
CaleHDF5GeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  CaleHDF5GeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the CaleHDF5 plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
CaleHDF5GeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
