// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <CaleHDF5PluginInfo.h>
#include <avtCaleHDF5FileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  CaleHDF5CommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a CaleHDF5 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
CaleHDF5CommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method: CaleHDF5CommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a CaleHDF5 database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A CaleHDF5 database from list.
//
//  Programmer: managan -- generated by xml2info
//  Creation:   Fri Oct 5 14:20:39 PST 2007
//
// ****************************************************************************

avtDatabase *
CaleHDF5CommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    // If the first file in the list is not a CALE file then this will
    // throw an exception, getting us out of here before we create objects
    // for the rest of the files.
    avtCaleHDF5FileFormat::Identify(list[0]);

    int nTimestep = nList / nBlock;
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nTimestep];
    for (int i = 0; i < nTimestep; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0; j < nBlock; j++)
        {
            ffl[i][j] = new avtCaleHDF5FileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}

