// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  CGNSPluginInfo.h
// ****************************************************************************

#ifndef CGNS_PLUGIN_INFO_H
#define CGNS_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: CGNSDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the CGNS plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//    Eric Brugger, Wed Feb 26 11:32:22 PST 2020
//    I added a dbType member to CGNSCommonPluginInfo.
//
// ****************************************************************************

class CGNSGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
    virtual std::vector<std::string> GetDefaultFilePatterns() const;
    virtual bool  AreDefaultFilePatternsStrict() const;
    virtual bool  OpensWholeDirectory() const;
};

class CGNSCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual CGNSGeneralPluginInfo
{
  public:
    CGNSCommonPluginInfo();

    virtual DatabaseType              GetDatabaseType();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);

  private:
    DatabaseType dbType;
};

class CGNSMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual CGNSCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class CGNSEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual CGNSCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
