// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CEAucdPluginInfo.C
// ****************************************************************************

#include <CEAucdPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(CEAucd,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(CEAucd,General)

// ****************************************************************************
//  Method: CEAucdGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CEAucdGeneralPluginInfo::GetName() const
{
    return "CEAucd";
}

// ****************************************************************************
//  Method: CEAucdGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CEAucdGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: CEAucdGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CEAucdGeneralPluginInfo::GetID() const
{
    return "CEAucd_1.0";
}
// ****************************************************************************
//  Method: CEAucdGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CEAucdGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: CEAucdGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CEAucdGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  CEAucdGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a CEAucd database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
CEAucdGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("U_#*.inp");
    defaultPatterns.push_back("U_#*_#*.inp");
    defaultPatterns.push_back("UCD_#*");
    defaultPatterns.push_back("UCD_#*_#*");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  CEAucdGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a CEAucd database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
CEAucdGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  CEAucdGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the CEAucd plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
CEAucdGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
