// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: Boxlib3DPluginInfo.C
// ****************************************************************************

#include <Boxlib3DPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Boxlib3D,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Boxlib3D,General)

// ****************************************************************************
//  Method: Boxlib3DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Boxlib3DGeneralPluginInfo::GetName() const
{
    return "Boxlib3D";
}

// ****************************************************************************
//  Method: Boxlib3DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Boxlib3DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: Boxlib3DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Boxlib3DGeneralPluginInfo::GetID() const
{
    return "Boxlib3D_1.0";
}
// ****************************************************************************
//  Method: Boxlib3DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Boxlib3DGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: Boxlib3DGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Boxlib3DGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  Boxlib3DGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Boxlib3D database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
Boxlib3DGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.boxlib3d");
    defaultPatterns.push_back("Header");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  Boxlib3DGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Boxlib3D database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Boxlib3DGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  Boxlib3DGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Boxlib3D plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Boxlib3DGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
