// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: Boxlib2DPluginInfo.C
// ****************************************************************************

#include <Boxlib2DPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Boxlib2D,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Boxlib2D,General)

// ****************************************************************************
//  Method: Boxlib2DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Boxlib2DGeneralPluginInfo::GetName() const
{
    return "Boxlib2D";
}

// ****************************************************************************
//  Method: Boxlib2DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Boxlib2DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: Boxlib2DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Boxlib2DGeneralPluginInfo::GetID() const
{
    return "Boxlib2D_1.0";
}
// ****************************************************************************
//  Method: Boxlib2DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Boxlib2DGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: Boxlib2DGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Boxlib2DGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  Boxlib2DGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Boxlib2D database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
Boxlib2DGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.boxlib2d");
    defaultPatterns.push_back("Header");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  Boxlib2DGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Boxlib2D database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Boxlib2DGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  Boxlib2DGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Boxlib2D plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Boxlib2DGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
