// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
// avtBlueprintFileFormat.h
// ************************************************************************* //

#ifndef AVT_BLUEPRINT_FILE_FORMAT_H
#define AVT_BLUEPRINT_FILE_FORMAT_H

#include "avtSTMDFileFormat.h"

#include "conduit.hpp"

// ****************************************************************************
//  Class: avtBlueprintFileFormat
//
//  Purpose:
//      Reads in Blueprint files as a plugin to VisIt.
//
//  Programmer: harrison37 -- generated by xml2avt
//  Creation:   Wed Jun 15 16:25:28 PST 2016
//
// ****************************************************************************

class avtBlueprintTreeCache;

class avtBlueprintFileFormat : public avtSTMDFileFormat
{
  public:
                           avtBlueprintFileFormat(const char *);
    virtual               ~avtBlueprintFileFormat();

    virtual const char    *GetType(void) 
                                { return "Blueprint"; }

    // Standard Mesh Access
    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

    // VisIt can't cache for us b/c we need to implement LOD support. 
    virtual bool           CanCacheVariable(const char *var)
                                { return false; }

    // Used to enable support for avtResolutionSelection
    virtual void           RegisterDataSelections(
                                const std::vector<avtDataSelection_p> &selList,
                                std::vector<bool> *selectionsApplied);
    // cycle and time support
    virtual int            GetCycle(void);
    virtual double         GetTime(void);

    
    virtual void           FreeUpResources(void); 

  protected:

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

    bool                   HasInvariantMetaData(void) const
                                { return false; }

    bool                   HasInvariantSIL(void) const
                                { return false; }

  private:

    void                   AddBlueprintMeshAndFieldMetadata(avtDatabaseMetaData *md,
                                                            std::string const &mesh_name, 
                                                            const conduit::Node &n_mesh_info);

    void                   ReadRootFile();

    void                   ReadRootIndexItems(const std::string &root_fname,
                                              const std::string &root_protocol,
                                              conduit::Node &root_info);

    void                   ReadBlueprintMesh(int domain,
                                             const std::string &abs_meshname,
                                             conduit::Node &out);

    void                   ReadBlueprintField(int domain,
                                              const std::string &abs_varname,
                                              conduit::Node &out);

    void                   FetchMeshAndTopoNames(const std::string &name_name_full,
                                                 std::string &mesh_name,
                                                 std::string &topo_name);


    conduit::Node          m_root_node;
    
    std::string            m_protocol;
    
    avtBlueprintTreeCache  *m_tree_cache;
  
    int                    m_selected_lod;

    conduit::Node          m_mesh_and_topo_info;

    std::map<std::string,bool> m_mfem_mesh_map;

};


#endif
