// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BlueprintPluginInfo.C
// ****************************************************************************

#include <BlueprintPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Blueprint,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Blueprint,General)

// ****************************************************************************
//  Method: BlueprintGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BlueprintGeneralPluginInfo::GetName() const
{
    return "Blueprint";
}

// ****************************************************************************
//  Method: BlueprintGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BlueprintGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: BlueprintGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BlueprintGeneralPluginInfo::GetID() const
{
    return "Blueprint_1.0";
}
// ****************************************************************************
//  Method: BlueprintGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
BlueprintGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: BlueprintGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
BlueprintGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  BlueprintGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Blueprint database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
BlueprintGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.blueprint_root");
    defaultPatterns.push_back("*.blueprint_root_hdf5");
    defaultPatterns.push_back("*.root");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  BlueprintGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Blueprint database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
BlueprintGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  BlueprintGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Blueprint plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
BlueprintGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
