// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtBATLOptions.C                              //
// ************************************************************************* //

#include <avtBATLOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetBATLReadOptions
//
//  Purpose:
//      Creates the options for BATL readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: hrchilds -- generated by xml2avt
//  Creation:   Thu Dec 17 14:06:38 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetBATLReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Show generating processor instead of refinement level", false);
    rv->SetBool("Use new style curve generation", true);
    return rv;
}


// ****************************************************************************
//  Function: GetBATLWriteOptions
//
//  Purpose:
//      Creates the options for BATL writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: hrchilds -- generated by xml2avt
//  Creation:   Thu Dec 17 14:06:38 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetBATLWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
