// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtAugDecompFileFormat.h                         //
// ************************************************************************* //

#ifndef AVT_AugDecomp_FILE_FORMAT_H
#define AVT_AugDecomp_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>
#include <string>

class CommonDatabasePluginInfo;
class avtFileFormatInterface;


// ****************************************************************************
//  Class: avtAugDecompFileFormat
//
//  Purpose:
//      Reads in AugDecomp files as a plugin to VisIt.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Wed Feb 13 08:58:40 PDT 2008
//
//  Modifications:
//    Brad Whitlock, Tue Jun 24 16:38:10 PDT 2008
//    Pass plugin info to the constructor.
//
// ****************************************************************************

class avtAugDecompFileFormat : public avtMTMDFileFormat
{
  public:
                       avtAugDecompFileFormat(const char *, 
                                              CommonDatabasePluginInfo *info);
    virtual           ~avtAugDecompFileFormat() {;};

    virtual void      *GetAuxiliaryData(const char *var, int timestep, 
                                        int domain, const char *type, void *args, 
                                        DestructorFunction &);

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    // virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "AugDecomp"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

  protected:
    avtFileFormatInterface         *interface;
    std::string                     filename;
    std::vector<std::string>        subset_names;
    std::vector<int>                zone_counts;
    std::vector<std::vector<int> >  subset_vals;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
};


#endif
