// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtADIOS2FileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_ADIOS2_LAMMPS_FILE_FORMAT_H
#define AVT_ADIOS2_LAMMPS_FILE_FORMAT_H

#include <avtMTSDFileFormat.h>

#include <vector>
#include <adios2.h>

// ****************************************************************************
//  Class: avtADIOS2FileFormat
//
//  Purpose:
//      Reads in ADIOS2 files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Thu Apr 12 08:39:47 PDT 2018
//
// ****************************************************************************

class avtLAMMPSFileFormat : public avtMTSDFileFormat
{
  public:
    static bool        Identify(const char *fname);
    static avtFileFormatInterface *CreateInterface(const char *const *list,
                                                   int nList,
                                                   int nBlock);

                       avtLAMMPSFileFormat(const char *);

    // interface creator with first file already opened
    static avtFileFormatInterface *CreateInterfaceADIOS2(
            const char *const *list,
            int nList,
            int nBlock,
            std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader,
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes
    );

    // constructor with already-opened stream
    avtLAMMPSFileFormat(std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader,
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes,
            const char *);

    virtual           ~avtLAMMPSFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep,
    //                                     const char *type, void *args,
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    //

    virtual int            GetNTimesteps() { return numTimeSteps; }
    virtual void        GetTimes(std::vector<double> &_times) { _times = times;}


    virtual const char    *GetType(void)   { return "LAMMPS"; };
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

    static bool IdentifyADIOS2(
                   std::map<std::string, adios2::Params> &variables,
                   std::map<std::string, adios2::Params> &attributes);


  protected:
    // DATA MEMBERS
    std::shared_ptr<adios2::ADIOS> adios;
    adios2::IO io;
    adios2::Engine reader;
    std::map<std::string, adios2::Params> variables, attributes;

    int numTimeSteps;
    std::vector<double> times;

    //Offsets for coords and scalars
    int numColumns;
    std::vector<int> coordOffset;
    std::map<std::string, int> scalarOffsets;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    int currentTimestep, numAtoms;
    void ReadTimestep(int timestate);
    std::vector<double> data;

    void GenerateTableOffsets(std::string &columnsStr);
};

#endif
