// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtADIOS2FileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_ADIOS2_BASE_FILE_FORMAT_H
#define AVT_ADIOS2_BASE_FILE_FORMAT_H

#include <avtMTSDFileFormat.h>

#include <vector>
#include <adios2.h>
#include <memory>

// ****************************************************************************
//  Class: avtADIOS2FileFormat
//
//  Purpose:
//      Reads in ADIOS2 files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Thu Apr 12 08:39:47 PDT 2018
//
// ****************************************************************************

class avtADIOS2BaseFileFormat : public avtMTSDFileFormat
{
  public:
    static bool        Identify(const char *fname);
    static avtFileFormatInterface *CreateInterface(const char *const *list,
                                                   int nList,
                                                   int nBlock);

                       avtADIOS2BaseFileFormat(const char *);

    // interface creator with first file already opened
    static avtFileFormatInterface *CreateInterfaceADIOS2(
            const char *const *list,
            int nList,
            int nBlock,
            std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader,
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes
            );

    // constructor with already-opened stream
    avtADIOS2BaseFileFormat(std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader,
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes,
            const char *);

    //virtual           ~avtADIOS2BaseFileFormat() {;};
    virtual           ~avtADIOS2BaseFileFormat();

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep,
    //                                     const char *type, void *args,
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    // virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "ADIOS2Base"; };
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    // DATA MEMBERS
    std::shared_ptr<adios2::ADIOS> adios;
    adios2::IO io;
    adios2::Engine reader;
    std::map<std::string, adios2::Params> variables;
    std::map<std::string, std::pair<int,std::string>> meshInfo;

    bool isClosed;


    int numTimeSteps;
    std::string engineName;
    bool stagingMode; // engine is staging or file-based?

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
};


#endif
