// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: ADIOS2PluginInfo.C
// ************************************************************************* //

#include <ADIOS2PluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ADIOS2,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(ADIOS2,General)

// ****************************************************************************
//  Method: ADIOS2GeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ADIOS2GeneralPluginInfo::GetName() const
{
    return "ADIOS2";
}

// ****************************************************************************
//  Method: ADIOS2GeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ADIOS2GeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ADIOS2GeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ADIOS2GeneralPluginInfo::GetID() const
{
    return "ADIOS2_1.0";
}
// ****************************************************************************
//  Method: ADIOS2GeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ADIOS2GeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ADIOS2GeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ADIOS2GeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  ADIOS2GeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a ADIOS2 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ADIOS2GeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.bp");
    defaultPatterns.push_back("*.bp.sst");
    defaultPatterns.push_back("*.bp.ssc");
    defaultPatterns.push_back("md.idx");
    defaultPatterns.push_back("md.0");
    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ADIOS2GeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a ADIOS2 database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ADIOS2GeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ADIOS2GeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the ADIOS2 plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ADIOS2GeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
