// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ADIOS2PluginInfo.h>
#include <avtADIOS2FileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ADIOS2CommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ADIOS2 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
ADIOS2CommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method: ADIOS2CommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a ADIOS2 database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ADIOS2 database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
ADIOS2CommonPluginInfo::SetupDatabase(const char *const *list,
                                      int nList, int nBlock)
{
    avtDatabase *db = 0;
    //
    // Create a file format interface.
    //
    avtFileFormatInterface *ffi = ADIOS2_CreateFileFormatInterface(list,
                                                                  nList,
                                                                  nBlock);
    //
    // If we created a file format interface, try creating a database.
    //
    if (ffi)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(ffi);
        }
        CATCH(VisItException)
        {
            delete ffi;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;
}

// ****************************************************************************
//  Method: ADIOS2CommonPluginInfo::GetLicense
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

std::string
ADIOS2CommonPluginInfo::GetLicense() const
{
    return std::string();
}
