// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "GeometricHelpers.h"

double geodesic_sphere_tess0_points[geodesic_sphere_tess0_npts][3] =
{
    {0.0, 0.525731112119, 0.850650808352},
    {0.0, -0.525731112119, 0.850650808352},
    {0.0, 0.525731112119, -0.850650808352},
    {0.0, -0.525731112119, -0.850650808352},
    {0.525731112119, 0.850650808352, 0.0},
    {-0.525731112119, 0.850650808352, 0.0},
    {0.525731112119, -0.850650808352, 0.0},
    {-0.525731112119, -0.850650808352, 0.0},
    {0.850650808352, 0.0, 0.525731112119},
    {0.850650808352, 0.0, -0.525731112119},
    {-0.850650808352, 0.0, 0.525731112119},
    {-0.850650808352, 0.0, -0.525731112119}
};

double geodesic_sphere_tess1_points[geodesic_sphere_tess1_npts][3] =
{
    {0.0, 0.525731112119, 0.850650808352},
    {0.0, -0.525731112119, 0.850650808352},
    {0.0, 0.525731112119, -0.850650808352},
    {0.0, -0.525731112119, -0.850650808352},
    {0.525731112119, 0.850650808352, 0.0},
    {-0.525731112119, 0.850650808352, 0.0},
    {0.525731112119, -0.850650808352, 0.0},
    {-0.525731112119, -0.850650808352, 0.0},
    {0.850650808352, 0.0, 0.525731112119},
    {0.850650808352, 0.0, -0.525731112119},
    {-0.850650808352, 0.0, 0.525731112119},
    {-0.850650808352, 0.0, -0.525731112119},
    {0.0, 0.0, 1.0},
    {0.5, -0.309016994375, 0.809016994375},
    {0.5, 0.309016994375, 0.809016994375},
    {0.809016994375, 0.5, 0.309016994375},
    {0.309016994375, 0.809016994375, 0.5},
    {0.0, 1.0, 0.0},
    {-0.309016994375, 0.809016994375, 0.5},
    {-0.809016994375, 0.5, 0.309016994375},
    {-0.5, 0.309016994375, 0.809016994375},
    {-0.5, -0.309016994375, 0.809016994375},
    {0.0, 0.0, -1.0},
    {-0.5, -0.309016994375, -0.809016994375},
    {-0.5, 0.309016994375, -0.809016994375},
    {-0.809016994375, 0.5, -0.309016994375},
    {-0.309016994375, 0.809016994375, -0.5},
    {0.309016994375, 0.809016994375, -0.5},
    {0.809016994375, 0.5, -0.309016994375},
    {0.5, 0.309016994375, -0.809016994375},
    {0.5, -0.309016994375, -0.809016994375},
    {-0.309016994375, -0.809016994375, 0.5},
    {-0.809016994375, -0.5, 0.309016994375},
    {-1.0, 0.0, 0.0},
    {-0.809016994375, -0.5, -0.309016994375},
    {-0.309016994375, -0.809016994375, -0.5},
    {0.309016994375, -0.809016994375, -0.5},
    {0.0, -1.0, 0.0},
    {0.309016994375, -0.809016994375, 0.5},
    {0.809016994375, -0.5, -0.309016994375},
    {1.0, 0.0, 0.0},
    {0.809016994375, -0.5, 0.309016994375}
};

double geodesic_sphere_tess2_points[geodesic_sphere_tess2_npts][3] =
{
    {0.0, 0.525731112119, 0.850650808352},
    {0.0, -0.525731112119, 0.850650808352},
    {0.0, 0.525731112119, -0.850650808352},
    {0.0, -0.525731112119, -0.850650808352},
    {0.525731112119, 0.850650808352, 0.0},
    {-0.525731112119, 0.850650808352, 0.0},
    {0.525731112119, -0.850650808352, 0.0},
    {-0.525731112119, -0.850650808352, 0.0},
    {0.850650808352, 0.0, 0.525731112119},
    {0.850650808352, 0.0, -0.525731112119},
    {-0.850650808352, 0.0, 0.525731112119},
    {-0.850650808352, 0.0, -0.525731112119},
    {0.0, 0.0, 1.0},
    {0.5, -0.309016994375, 0.809016994375},
    {0.5, 0.309016994375, 0.809016994375},
    {0.809016994375, 0.5, 0.309016994375},
    {0.309016994375, 0.809016994375, 0.5},
    {0.0, 1.0, 0.0},
    {-0.309016994375, 0.809016994375, 0.5},
    {-0.809016994375, 0.5, 0.309016994375},
    {-0.5, 0.309016994375, 0.809016994375},
    {-0.5, -0.309016994375, 0.809016994375},
    {0.0, 0.0, -1.0},
    {-0.5, -0.309016994375, -0.809016994375},
    {-0.5, 0.309016994375, -0.809016994375},
    {-0.809016994375, 0.5, -0.309016994375},
    {-0.309016994375, 0.809016994375, -0.5},
    {0.309016994375, 0.809016994375, -0.5},
    {0.809016994375, 0.5, -0.309016994375},
    {0.5, 0.309016994375, -0.809016994375},
    {0.5, -0.309016994375, -0.809016994375},
    {-0.309016994375, -0.809016994375, 0.5},
    {-0.809016994375, -0.5, 0.309016994375},
    {-1.0, 0.0, 0.0},
    {-0.809016994375, -0.5, -0.309016994375},
    {-0.309016994375, -0.809016994375, -0.5},
    {0.309016994375, -0.809016994375, -0.5},
    {0.0, -1.0, 0.0},
    {0.309016994375, -0.809016994375, 0.5},
    {0.809016994375, -0.5, -0.309016994375},
    {1.0, 0.0, 0.0},
    {0.809016994375, -0.5, 0.309016994375},
    {0.0, 0.273266528913, 0.961938357784},
    {0.26286555606, 0.162459848116, 0.951056516295},
    {0.259891913008, 0.433888564553, 0.862668480416},
    {0.0, -0.273266528913, 0.961938357784},
    {0.259891913008, -0.433888564553, 0.862668480416},
    {0.26286555606, -0.162459848116, 0.951056516295},
    {0.525731112119, 0.0, 0.850650808352},
    {0.702046444776, -0.16062203564, 0.69378047756},
    {0.702046444776, 0.16062203564, 0.69378047756},
    {0.425325404176, 0.587785252292, 0.688190960236},
    {0.16062203564, 0.69378047756, 0.702046444776},
    {0.862668480416, 0.259891913008, 0.433888564553},
    {0.688190960236, 0.425325404176, 0.587785252292},
    {0.587785252292, 0.688190960236, 0.425325404176},
    {0.69378047756, 0.702046444776, 0.16062203564},
    {0.433888564553, 0.862668480416, 0.259891913008},
    {0.0, 0.850650808352, 0.525731112119},
    {-0.16062203564, 0.69378047756, 0.702046444776},
    {0.273266528913, 0.961938357784, 0.0},
    {0.162459848116, 0.951056516295, 0.26286555606},
    {-0.162459848116, 0.951056516295, 0.26286555606},
    {-0.273266528913, 0.961938357784, 0.0},
    {-0.433888564553, 0.862668480416, 0.259891913008},
    {-0.425325404176, 0.587785252292, 0.688190960236},
    {-0.259891913008, 0.433888564553, 0.862668480416},
    {-0.69378047756, 0.702046444776, 0.16062203564},
    {-0.587785252292, 0.688190960236, 0.425325404176},
    {-0.688190960236, 0.425325404176, 0.587785252292},
    {-0.862668480416, 0.259891913008, 0.433888564553},
    {-0.702046444776, 0.16062203564, 0.69378047756},
    {-0.26286555606, 0.162459848116, 0.951056516295},
    {-0.702046444776, -0.16062203564, 0.69378047756},
    {-0.525731112119, 0.0, 0.850650808352},
    {-0.26286555606, -0.162459848116, 0.951056516295},
    {-0.259891913008, -0.433888564553, 0.862668480416},
    {0.0, 0.273266528913, -0.961938357784},
    {-0.26286555606, 0.162459848116, -0.951056516295},
    {-0.259891913008, 0.433888564553, -0.862668480416},
    {0.0, -0.273266528913, -0.961938357784},
    {-0.259891913008, -0.433888564553, -0.862668480416},
    {-0.26286555606, -0.162459848116, -0.951056516295},
    {-0.525731112119, 0.0, -0.850650808352},
    {-0.702046444776, -0.16062203564, -0.69378047756},
    {-0.702046444776, 0.16062203564, -0.69378047756},
    {-0.425325404176, 0.587785252292, -0.688190960236},
    {-0.16062203564, 0.69378047756, -0.702046444776},
    {-0.862668480416, 0.259891913008, -0.433888564553},
    {-0.688190960236, 0.425325404176, -0.587785252292},
    {-0.587785252292, 0.688190960236, -0.425325404176},
    {-0.69378047756, 0.702046444776, -0.16062203564},
    {-0.433888564553, 0.862668480416, -0.259891913008},
    {0.0, 0.850650808352, -0.525731112119},
    {0.16062203564, 0.69378047756, -0.702046444776},
    {-0.162459848116, 0.951056516295, -0.26286555606},
    {0.162459848116, 0.951056516295, -0.26286555606},
    {0.433888564553, 0.862668480416, -0.259891913008},
    {0.425325404176, 0.587785252292, -0.688190960236},
    {0.259891913008, 0.433888564553, -0.862668480416},
    {0.69378047756, 0.702046444776, -0.16062203564},
    {0.587785252292, 0.688190960236, -0.425325404176},
    {0.688190960236, 0.425325404176, -0.587785252292},
    {0.862668480416, 0.259891913008, -0.433888564553},
    {0.702046444776, 0.16062203564, -0.69378047756},
    {0.26286555606, 0.162459848116, -0.951056516295},
    {0.702046444776, -0.16062203564, -0.69378047756},
    {0.525731112119, 0.0, -0.850650808352},
    {0.26286555606, -0.162459848116, -0.951056516295},
    {0.259891913008, -0.433888564553, -0.862668480416},
    {-0.433888564553, -0.862668480416, 0.259891913008},
    {-0.587785252292, -0.688190960236, 0.425325404176},
    {-0.69378047756, -0.702046444776, 0.16062203564},
    {-0.16062203564, -0.69378047756, 0.702046444776},
    {-0.425325404176, -0.587785252292, 0.688190960236},
    {-0.688190960236, -0.425325404176, 0.587785252292},
    {-0.862668480416, -0.259891913008, 0.433888564553},
    {-0.850650808352, -0.525731112119, 0.0},
    {-0.69378047756, -0.702046444776, -0.16062203564},
    {-0.961938357784, 0.0, 0.273266528913},
    {-0.951056516295, -0.26286555606, 0.162459848116},
    {-0.951056516295, -0.26286555606, -0.162459848116},
    {-0.961938357784, 0.0, -0.273266528913},
    {-0.862668480416, -0.259891913008, -0.433888564553},
    {-0.587785252292, -0.688190960236, -0.425325404176},
    {-0.433888564553, -0.862668480416, -0.259891913008},
    {-0.688190960236, -0.425325404176, -0.587785252292},
    {-0.425325404176, -0.587785252292, -0.688190960236},
    {-0.16062203564, -0.69378047756, -0.702046444776},
    {-0.162459848116, -0.951056516295, -0.26286555606},
    {-0.273266528913, -0.961938357784, 0.0},
    {0.16062203564, -0.69378047756, -0.702046444776},
    {0.0, -0.850650808352, -0.525731112119},
    {0.162459848116, -0.951056516295, -0.26286555606},
    {0.433888564553, -0.862668480416, -0.259891913008},
    {0.273266528913, -0.961938357784, 0.0},
    {-0.162459848116, -0.951056516295, 0.26286555606},
    {0.433888564553, -0.862668480416, 0.259891913008},
    {0.162459848116, -0.951056516295, 0.26286555606},
    {0.0, -0.850650808352, 0.525731112119},
    {0.16062203564, -0.69378047756, 0.702046444776},
    {0.587785252292, -0.688190960236, -0.425325404176},
    {0.69378047756, -0.702046444776, -0.16062203564},
    {0.425325404176, -0.587785252292, -0.688190960236},
    {0.688190960236, -0.425325404176, -0.587785252292},
    {0.862668480416, -0.259891913008, -0.433888564553},
    {0.850650808352, -0.525731112119, 0.0},
    {0.69378047756, -0.702046444776, 0.16062203564},
    {0.961938357784, 0.0, -0.273266528913},
    {0.951056516295, -0.26286555606, -0.162459848116},
    {0.951056516295, -0.26286555606, 0.162459848116},
    {0.961938357784, 0.0, 0.273266528913},
    {0.862668480416, -0.259891913008, 0.433888564553},
    {0.587785252292, -0.688190960236, 0.425325404176},
    {0.688190960236, -0.425325404176, 0.587785252292},
    {0.425325404176, -0.587785252292, 0.688190960236},
    {-0.850650808352, 0.525731112119, 0.0},
    {-0.951056516295, 0.26286555606, -0.162459848116},
    {-0.951056516295, 0.26286555606, 0.162459848116},
    {0.850650808352, 0.525731112119, 0.0},
    {0.951056516295, 0.26286555606, 0.162459848116},
    {0.951056516295, 0.26286555606, -0.162459848116}
};

int geodesic_sphere_tess0_tris[geodesic_sphere_tess0_ntris][3] =
{
    {0, 1, 8},
    {0, 8, 4},
    {0, 4, 5},
    {0, 5, 10},
    {0, 10, 1},
    {2, 3, 11},
    {2, 11, 5},
    {2, 5, 4},
    {2, 4, 9},
    {2, 9, 3},
    {7, 1, 10},
    {7, 10, 11},
    {7, 11, 3},
    {7, 3, 6},
    {7, 6, 1},
    {6, 3, 9},
    {6, 9, 8},
    {6, 8, 1},
    {5, 11, 10},
    {4, 8, 9}
};

int geodesic_sphere_tess1_tris[geodesic_sphere_tess1_ntris][3] =
{
    {0, 12, 14},
    {12, 1, 13},
    {14, 13, 8},
    {12, 13, 14},
    {0, 14, 16},
    {14, 8, 15},
    {16, 15, 4},
    {14, 15, 16},
    {0, 16, 18},
    {16, 4, 17},
    {18, 17, 5},
    {16, 17, 18},
    {0, 18, 20},
    {18, 5, 19},
    {20, 19, 10},
    {18, 19, 20},
    {0, 20, 12},
    {20, 10, 21},
    {12, 21, 1},
    {20, 21, 12},
    {2, 22, 24},
    {22, 3, 23},
    {24, 23, 11},
    {22, 23, 24},
    {2, 24, 26},
    {24, 11, 25},
    {26, 25, 5},
    {24, 25, 26},
    {2, 26, 27},
    {26, 5, 17},
    {27, 17, 4},
    {26, 17, 27},
    {2, 27, 29},
    {27, 4, 28},
    {29, 28, 9},
    {27, 28, 29},
    {2, 29, 22},
    {29, 9, 30},
    {22, 30, 3},
    {29, 30, 22},
    {7, 31, 32},
    {31, 1, 21},
    {32, 21, 10},
    {31, 21, 32},
    {7, 32, 34},
    {32, 10, 33},
    {34, 33, 11},
    {32, 33, 34},
    {7, 34, 35},
    {34, 11, 23},
    {35, 23, 3},
    {34, 23, 35},
    {7, 35, 37},
    {35, 3, 36},
    {37, 36, 6},
    {35, 36, 37},
    {7, 37, 31},
    {37, 6, 38},
    {31, 38, 1},
    {37, 38, 31},
    {6, 36, 39},
    {36, 3, 30},
    {39, 30, 9},
    {36, 30, 39},
    {6, 39, 41},
    {39, 9, 40},
    {41, 40, 8},
    {39, 40, 41},
    {6, 41, 38},
    {41, 8, 13},
    {38, 13, 1},
    {41, 13, 38},
    {5, 25, 19},
    {25, 11, 33},
    {19, 33, 10},
    {25, 33, 19},
    {4, 15, 28},
    {15, 8, 40},
    {28, 40, 9},
    {15, 40, 28}
};

int geodesic_sphere_tess2_tris[geodesic_sphere_tess2_ntris][3] =
{
    {0, 42, 44},
    {42, 12, 43},
    {44, 43, 14},
    {42, 43, 44},
    {12, 45, 47},
    {45, 1, 46},
    {47, 46, 13},
    {45, 46, 47},
    {14, 48, 50},
    {48, 13, 49},
    {50, 49, 8},
    {48, 49, 50},
    {12, 47, 43},
    {47, 13, 48},
    {43, 48, 14},
    {47, 48, 43},
    {0, 44, 52},
    {44, 14, 51},
    {52, 51, 16},
    {44, 51, 52},
    {14, 50, 54},
    {50, 8, 53},
    {54, 53, 15},
    {50, 53, 54},
    {16, 55, 57},
    {55, 15, 56},
    {57, 56, 4},
    {55, 56, 57},
    {14, 54, 51},
    {54, 15, 55},
    {51, 55, 16},
    {54, 55, 51},
    {0, 52, 59},
    {52, 16, 58},
    {59, 58, 18},
    {52, 58, 59},
    {16, 57, 61},
    {57, 4, 60},
    {61, 60, 17},
    {57, 60, 61},
    {18, 62, 64},
    {62, 17, 63},
    {64, 63, 5},
    {62, 63, 64},
    {16, 61, 58},
    {61, 17, 62},
    {58, 62, 18},
    {61, 62, 58},
    {0, 59, 66},
    {59, 18, 65},
    {66, 65, 20},
    {59, 65, 66},
    {18, 64, 68},
    {64, 5, 67},
    {68, 67, 19},
    {64, 67, 68},
    {20, 69, 71},
    {69, 19, 70},
    {71, 70, 10},
    {69, 70, 71},
    {18, 68, 65},
    {68, 19, 69},
    {65, 69, 20},
    {68, 69, 65},
    {0, 66, 42},
    {66, 20, 72},
    {42, 72, 12},
    {66, 72, 42},
    {20, 71, 74},
    {71, 10, 73},
    {74, 73, 21},
    {71, 73, 74},
    {12, 75, 45},
    {75, 21, 76},
    {45, 76, 1},
    {75, 76, 45},
    {20, 74, 72},
    {74, 21, 75},
    {72, 75, 12},
    {74, 75, 72},
    {2, 77, 79},
    {77, 22, 78},
    {79, 78, 24},
    {77, 78, 79},
    {22, 80, 82},
    {80, 3, 81},
    {82, 81, 23},
    {80, 81, 82},
    {24, 83, 85},
    {83, 23, 84},
    {85, 84, 11},
    {83, 84, 85},
    {22, 82, 78},
    {82, 23, 83},
    {78, 83, 24},
    {82, 83, 78},
    {2, 79, 87},
    {79, 24, 86},
    {87, 86, 26},
    {79, 86, 87},
    {24, 85, 89},
    {85, 11, 88},
    {89, 88, 25},
    {85, 88, 89},
    {26, 90, 92},
    {90, 25, 91},
    {92, 91, 5},
    {90, 91, 92},
    {24, 89, 86},
    {89, 25, 90},
    {86, 90, 26},
    {89, 90, 86},
    {2, 87, 94},
    {87, 26, 93},
    {94, 93, 27},
    {87, 93, 94},
    {26, 92, 95},
    {92, 5, 63},
    {95, 63, 17},
    {92, 63, 95},
    {27, 96, 97},
    {96, 17, 60},
    {97, 60, 4},
    {96, 60, 97},
    {26, 95, 93},
    {95, 17, 96},
    {93, 96, 27},
    {95, 96, 93},
    {2, 94, 99},
    {94, 27, 98},
    {99, 98, 29},
    {94, 98, 99},
    {27, 97, 101},
    {97, 4, 100},
    {101, 100, 28},
    {97, 100, 101},
    {29, 102, 104},
    {102, 28, 103},
    {104, 103, 9},
    {102, 103, 104},
    {27, 101, 98},
    {101, 28, 102},
    {98, 102, 29},
    {101, 102, 98},
    {2, 99, 77},
    {99, 29, 105},
    {77, 105, 22},
    {99, 105, 77},
    {29, 104, 107},
    {104, 9, 106},
    {107, 106, 30},
    {104, 106, 107},
    {22, 108, 80},
    {108, 30, 109},
    {80, 109, 3},
    {108, 109, 80},
    {29, 107, 105},
    {107, 30, 108},
    {105, 108, 22},
    {107, 108, 105},
    {7, 110, 112},
    {110, 31, 111},
    {112, 111, 32},
    {110, 111, 112},
    {31, 113, 114},
    {113, 1, 76},
    {114, 76, 21},
    {113, 76, 114},
    {32, 115, 116},
    {115, 21, 73},
    {116, 73, 10},
    {115, 73, 116},
    {31, 114, 111},
    {114, 21, 115},
    {111, 115, 32},
    {114, 115, 111},
    {7, 112, 118},
    {112, 32, 117},
    {118, 117, 34},
    {112, 117, 118},
    {32, 116, 120},
    {116, 10, 119},
    {120, 119, 33},
    {116, 119, 120},
    {34, 121, 123},
    {121, 33, 122},
    {123, 122, 11},
    {121, 122, 123},
    {32, 120, 117},
    {120, 33, 121},
    {117, 121, 34},
    {120, 121, 117},
    {7, 118, 125},
    {118, 34, 124},
    {125, 124, 35},
    {118, 124, 125},
    {34, 123, 126},
    {123, 11, 84},
    {126, 84, 23},
    {123, 84, 126},
    {35, 127, 128},
    {127, 23, 81},
    {128, 81, 3},
    {127, 81, 128},
    {34, 126, 124},
    {126, 23, 127},
    {124, 127, 35},
    {126, 127, 124},
    {7, 125, 130},
    {125, 35, 129},
    {130, 129, 37},
    {125, 129, 130},
    {35, 128, 132},
    {128, 3, 131},
    {132, 131, 36},
    {128, 131, 132},
    {37, 133, 135},
    {133, 36, 134},
    {135, 134, 6},
    {133, 134, 135},
    {35, 132, 129},
    {132, 36, 133},
    {129, 133, 37},
    {132, 133, 129},
    {7, 130, 110},
    {130, 37, 136},
    {110, 136, 31},
    {130, 136, 110},
    {37, 135, 138},
    {135, 6, 137},
    {138, 137, 38},
    {135, 137, 138},
    {31, 139, 113},
    {139, 38, 140},
    {113, 140, 1},
    {139, 140, 113},
    {37, 138, 136},
    {138, 38, 139},
    {136, 139, 31},
    {138, 139, 136},
    {6, 134, 142},
    {134, 36, 141},
    {142, 141, 39},
    {134, 141, 142},
    {36, 131, 143},
    {131, 3, 109},
    {143, 109, 30},
    {131, 109, 143},
    {39, 144, 145},
    {144, 30, 106},
    {145, 106, 9},
    {144, 106, 145},
    {36, 143, 141},
    {143, 30, 144},
    {141, 144, 39},
    {143, 144, 141},
    {6, 142, 147},
    {142, 39, 146},
    {147, 146, 41},
    {142, 146, 147},
    {39, 145, 149},
    {145, 9, 148},
    {149, 148, 40},
    {145, 148, 149},
    {41, 150, 152},
    {150, 40, 151},
    {152, 151, 8},
    {150, 151, 152},
    {39, 149, 146},
    {149, 40, 150},
    {146, 150, 41},
    {149, 150, 146},
    {6, 147, 137},
    {147, 41, 153},
    {137, 153, 38},
    {147, 153, 137},
    {41, 152, 154},
    {152, 8, 49},
    {154, 49, 13},
    {152, 49, 154},
    {38, 155, 140},
    {155, 13, 46},
    {140, 46, 1},
    {155, 46, 140},
    {41, 154, 153},
    {154, 13, 155},
    {153, 155, 38},
    {154, 155, 153},
    {5, 91, 67},
    {91, 25, 156},
    {67, 156, 19},
    {91, 156, 67},
    {25, 88, 157},
    {88, 11, 122},
    {157, 122, 33},
    {88, 122, 157},
    {19, 158, 70},
    {158, 33, 119},
    {70, 119, 10},
    {158, 119, 70},
    {25, 157, 156},
    {157, 33, 158},
    {156, 158, 19},
    {157, 158, 156},
    {4, 56, 100},
    {56, 15, 159},
    {100, 159, 28},
    {56, 159, 100},
    {15, 53, 160},
    {53, 8, 151},
    {160, 151, 40},
    {53, 151, 160},
    {28, 161, 103},
    {161, 40, 148},
    {103, 148, 9},
    {161, 148, 103},
    {15, 160, 159},
    {160, 40, 161},
    {159, 161, 28},
    {160, 161, 159}
};
