// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef VIEWERCLIENTINFORMATIONELEMENT_H
#define VIEWERCLIENTINFORMATIONELEMENT_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ViewerClientInformationElement
//
// Purpose:
//    This class contains the raw element
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ViewerClientInformationElement : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ViewerClientInformationElement();
    ViewerClientInformationElement(const ViewerClientInformationElement &obj);
protected:
    // These constructors are for objects derived from this class
    ViewerClientInformationElement(private_tmfs_t tmfs);
    ViewerClientInformationElement(const ViewerClientInformationElement &obj, private_tmfs_t tmfs);
public:
    virtual ~ViewerClientInformationElement();

    virtual ViewerClientInformationElement& operator = (const ViewerClientInformationElement &obj);
    virtual bool operator == (const ViewerClientInformationElement &obj) const;
    virtual bool operator != (const ViewerClientInformationElement &obj) const;
private:
    void Init();
    void Copy(const ViewerClientInformationElement &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectData();
    void SelectRawData();

    // Property setting methods
    void SetData(const std::string &data_);
    void SetRawData(const unsignedCharVector &rawData_);
    void SetFormat(int format_);
    void SetIsRaw(bool isRaw_);
    void SetWindowId(int windowId_);

    // Property getting methods
    const std::string        &GetData() const;
          std::string        &GetData();
    const unsignedCharVector &GetRawData() const;
          unsignedCharVector &GetRawData();
    int                      GetFormat() const;
    bool                     GetIsRaw() const;
    int                      GetWindowId() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_data = 0,
        ID_rawData,
        ID_format,
        ID_isRaw,
        ID_windowId,
        ID__LAST
    };

private:
    std::string        data;
    unsignedCharVector rawData;
    int                format;
    bool               isRaw;
    int                windowId;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VIEWERCLIENTINFORMATIONELEMENT_TMFS "su*ibi"

#endif
