// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef VIEWERCLIENTATTRIBUTES_H
#define VIEWERCLIENTATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ViewerClientAttributes
//
// Purpose:
//    This class contains attributes used for viewer client
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ViewerClientAttributes : public AttributeSubject
{
public:
    enum RenderType
    {
        None,
        Image,
        Data
    };

    // These constructors are for objects of this class
    ViewerClientAttributes();
    ViewerClientAttributes(const ViewerClientAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ViewerClientAttributes(private_tmfs_t tmfs);
    ViewerClientAttributes(const ViewerClientAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ViewerClientAttributes();

    virtual ViewerClientAttributes& operator = (const ViewerClientAttributes &obj);
    virtual bool operator == (const ViewerClientAttributes &obj) const;
    virtual bool operator != (const ViewerClientAttributes &obj) const;
private:
    void Init();
    void Copy(const ViewerClientAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectTitle();
    void SelectWindowIds();
    void SelectRenderingTypes();

    // Property setting methods
    void SetRenderingType(RenderType renderingType_);
    void SetId(int id_);
    void SetTitle(const std::string &title_);
    void SetWindowIds(const intVector &windowIds_);
    void SetImageWidth(int imageWidth_);
    void SetImageHeight(int imageHeight_);
    void SetImageResolutionPcnt(double imageResolutionPcnt_);
    void SetExternalClient(bool externalClient_);
    void SetRenderingTypes(const intVector &renderingTypes_);

    // Property getting methods
    RenderType        GetRenderingType() const;
    int               GetId() const;
    const std::string &GetTitle() const;
          std::string &GetTitle();
    const intVector   &GetWindowIds() const;
          intVector   &GetWindowIds();
    int               GetImageWidth() const;
    int               GetImageHeight() const;
    double            GetImageResolutionPcnt() const;
    bool              GetExternalClient() const;
    const intVector   &GetRenderingTypes() const;
          intVector   &GetRenderingTypes();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string RenderType_ToString(RenderType);
    static bool RenderType_FromString(const std::string &, RenderType &);
protected:
    static std::string RenderType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_renderingType = 0,
        ID_id,
        ID_title,
        ID_windowIds,
        ID_imageWidth,
        ID_imageHeight,
        ID_imageResolutionPcnt,
        ID_externalClient,
        ID_renderingTypes,
        ID__LAST
    };

private:
    int         renderingType;
    int         id;
    std::string title;
    intVector   windowIds;
    int         imageWidth;
    int         imageHeight;
    double      imageResolutionPcnt;
    bool        externalClient;
    intVector   renderingTypes;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VIEWERCLIENTATTRIBUTES_TMFS "iisi*iidbi*"

#endif
