// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef THRESHOLDOPATTRIBUTES_H
#define THRESHOLDOPATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ThresholdOpAttributes
//
// Purpose:
//    This class contains attributes for the threshold operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ThresholdOpAttributes : public AttributeSubject
{
public:
    enum OutputMeshType
    {
        InputZones,
        PointMesh
    };
    enum ZonePortion
    {
        EntireZone,
        PartOfZone
    };
    enum BoundsInputType
    {
        Default,
        Custom
    };

    // These constructors are for objects of this class
    ThresholdOpAttributes();
    ThresholdOpAttributes(const ThresholdOpAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ThresholdOpAttributes(private_tmfs_t tmfs);
    ThresholdOpAttributes(const ThresholdOpAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ThresholdOpAttributes();

    virtual ThresholdOpAttributes& operator = (const ThresholdOpAttributes &obj);
    virtual bool operator == (const ThresholdOpAttributes &obj) const;
    virtual bool operator != (const ThresholdOpAttributes &obj) const;
private:
    void Init();
    void Copy(const ThresholdOpAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectListedVarNames();
    void SelectZonePortions();
    void SelectLowerBounds();
    void SelectUpperBounds();
    void SelectDefaultVarName();
    void SelectBoundsRange();
    void SetOutputMeshType(int outputMeshType_);
    void SetBoundsInputType(int boundsInputType_);
    void SetListedVarNames(const stringVector &listedVarNames_);
    void SetZonePortions(const intVector &zonePortions_);
    void SetLowerBounds(const doubleVector &lowerBounds_);
    void SetUpperBounds(const doubleVector &upperBounds_);
    void SetDefaultVarName(const std::string &defaultVarName_);
    void SetDefaultVarIsScalar(bool defaultVarIsScalar_);
    void SetBoundsRange(const stringVector &boundsRange_);
    int                GetOutputMeshType() const;
    int                GetBoundsInputType() const;
    const stringVector &GetListedVarNames() const;
          stringVector &GetListedVarNames();
    const intVector    &GetZonePortions() const;
          intVector    &GetZonePortions();
    const doubleVector &GetLowerBounds() const;
          doubleVector &GetLowerBounds();
    const doubleVector &GetUpperBounds() const;
          doubleVector &GetUpperBounds();
    const std::string  &GetDefaultVarName() const;
          std::string  &GetDefaultVarName();
    bool               GetDefaultVarIsScalar() const;
    const stringVector &GetBoundsRange() const;
          stringVector &GetBoundsRange();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string OutputMeshType_ToString(OutputMeshType);
    static bool OutputMeshType_FromString(const std::string &, OutputMeshType &);
protected:
    static std::string OutputMeshType_ToString(int);
public:
    static std::string ZonePortion_ToString(ZonePortion);
    static bool ZonePortion_FromString(const std::string &, ZonePortion &);
protected:
    static std::string ZonePortion_ToString(int);
public:
    static std::string BoundsInputType_ToString(BoundsInputType);
    static bool BoundsInputType_FromString(const std::string &, BoundsInputType &);
protected:
    static std::string BoundsInputType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void SupplyMissingDefaultsIfAppropriate();
    bool AttributesAreConsistent() const;
    void ForceAttributeConsistency();
    void SwitchDefaultVariableNameToTrueName();

    // IDs that can be used to identify fields in case statements
    enum {
        ID_outputMeshType = 0,
        ID_boundsInputType,
        ID_listedVarNames,
        ID_zonePortions,
        ID_lowerBounds,
        ID_upperBounds,
        ID_defaultVarName,
        ID_defaultVarIsScalar,
        ID_boundsRange,
        ID__LAST
    };

protected:
    int          outputMeshType;
    int          boundsInputType;
    stringVector listedVarNames;
    intVector    zonePortions;
    doubleVector lowerBounds;
    doubleVector upperBounds;
    std::string  defaultVarName;
    bool         defaultVarIsScalar;
    stringVector boundsRange;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define THRESHOLDOPATTRIBUTES_TMFS "iis*i*d*d*sbs*"

#endif
