// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SYNCATTRIBUTES_H
#define SYNCATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SyncAttributes
//
// Purpose:
//    This class contains an integer that can be used to synchronize the viewer and its clients.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SyncAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SyncAttributes();
    SyncAttributes(const SyncAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SyncAttributes(private_tmfs_t tmfs);
    SyncAttributes(const SyncAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SyncAttributes();

    virtual SyncAttributes& operator = (const SyncAttributes &obj);
    virtual bool operator == (const SyncAttributes &obj) const;
    virtual bool operator != (const SyncAttributes &obj) const;
private:
    void Init();
    void Copy(const SyncAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetSyncTag(int syncTag_);

    // Property getting methods
    int GetSyncTag() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_syncTag = 0,
        ID__LAST
    };

private:
    int syncTag;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SYNCATTRIBUTES_TMFS "i"

#endif
