// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef STATUSATTRIBUTES_H
#define STATUSATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: StatusAttributes
//
// Purpose:
//    This class contains the status that is displayed in the GUI's status bar.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API StatusAttributes : public AttributeSubject
{
public:
    static const int DEFAULT_DURATION;

    // These constructors are for objects of this class
    StatusAttributes();
    StatusAttributes(const StatusAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    StatusAttributes(private_tmfs_t tmfs);
    StatusAttributes(const StatusAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~StatusAttributes();

    virtual StatusAttributes& operator = (const StatusAttributes &obj);
    virtual bool operator == (const StatusAttributes &obj) const;
    virtual bool operator != (const StatusAttributes &obj) const;
private:
    void Init();
    void Copy(const StatusAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectSender();
    void SelectStatusMessage();
    void SelectUnicode();
    void SelectCurrentStageName();

    // Property setting methods
    void SetSender(const std::string &sender_);
    void SetClearStatus(bool clearStatus_);
    void SetStatusMessage(const std::string &statusMessage_);
    void SetUnicode(const unsignedCharVector &unicode_);
    void SetHasUnicode(bool hasUnicode_);
    void SetPercent(int percent_);
    void SetCurrentStage(int currentStage_);
    void SetCurrentStageName(const std::string &currentStageName_);
    void SetMaxStage(int maxStage_);
    void SetMessageType(int messageType_);
    void SetDuration(int duration_);

    // Property getting methods
    const std::string        &GetSender() const;
          std::string        &GetSender();
    bool                     GetClearStatus() const;
    const std::string        &GetStatusMessage() const;
          std::string        &GetStatusMessage();
    const unsignedCharVector &GetUnicode() const;
          unsignedCharVector &GetUnicode();
    bool                     GetHasUnicode() const;
    int                      GetPercent() const;
    int                      GetCurrentStage() const;
    const std::string        &GetCurrentStageName() const;
          std::string        &GetCurrentStageName();
    int                      GetMaxStage() const;
    int                      GetMessageType() const;
    int                      GetDuration() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_sender = 0,
        ID_clearStatus,
        ID_statusMessage,
        ID_unicode,
        ID_hasUnicode,
        ID_percent,
        ID_currentStage,
        ID_currentStageName,
        ID_maxStage,
        ID_messageType,
        ID_duration,
        ID__LAST
    };

private:
    std::string        sender;
    bool               clearStatus;
    std::string        statusMessage;
    unsignedCharVector unicode;
    bool               hasUnicode;
    int                percent;
    int                currentStage;
    std::string        currentStageName;
    int                maxStage;
    int                messageType;
    int                duration;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define STATUSATTRIBUTES_TMFS "sbsu*biisiii"

#endif
