// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SPHEREATTRIBUTES_H
#define SPHEREATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SphereAttributes
//
// Purpose:
//    Attributes for a sphere
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SphereAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SphereAttributes();
    SphereAttributes(const SphereAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SphereAttributes(private_tmfs_t tmfs);
    SphereAttributes(const SphereAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SphereAttributes();

    virtual SphereAttributes& operator = (const SphereAttributes &obj);
    virtual bool operator == (const SphereAttributes &obj) const;
    virtual bool operator != (const SphereAttributes &obj) const;
private:
    void Init();
    void Copy(const SphereAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectOrigin();

    // Property setting methods
    void SetOrigin(const double *origin_);
    void SetRadius(double radius_);

    // Property getting methods
    const double *GetOrigin() const;
          double *GetOrigin();
    double       GetRadius() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_origin = 0,
        ID_radius,
        ID__LAST
    };

private:
    double origin[3];
    double radius;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SPHEREATTRIBUTES_TMFS "Dd"

#endif
