// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SAVESUBWINDOWATTRIBUTES_H
#define SAVESUBWINDOWATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SaveSubWindowAttributes
//
// Purpose:
//    The attributes for saving a sub window
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SaveSubWindowAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SaveSubWindowAttributes();
    SaveSubWindowAttributes(const SaveSubWindowAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SaveSubWindowAttributes(private_tmfs_t tmfs);
    SaveSubWindowAttributes(const SaveSubWindowAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SaveSubWindowAttributes();

    virtual SaveSubWindowAttributes& operator = (const SaveSubWindowAttributes &obj);
    virtual bool operator == (const SaveSubWindowAttributes &obj) const;
    virtual bool operator != (const SaveSubWindowAttributes &obj) const;
private:
    void Init();
    void Copy(const SaveSubWindowAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPosition();
    void SelectSize();

    // Property setting methods
    void SetPosition(const int *position_);
    void SetSize(const int *size_);
    void SetLayer(int layer_);
    void SetTransparency(double transparency_);
    void SetOmitWindow(bool omitWindow_);

    // Property getting methods
    const int *GetPosition() const;
          int *GetPosition();
    const int *GetSize() const;
          int *GetSize();
    int       GetLayer() const;
    double    GetTransparency() const;
    bool      GetOmitWindow() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_position = 0,
        ID_size,
        ID_layer,
        ID_transparency,
        ID_omitWindow,
        ID__LAST
    };

private:
    int    position[2];
    int    size[2];
    int    layer;
    double transparency;
    bool   omitWindow;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SAVESUBWINDOWATTRIBUTES_TMFS "IIidb"

#endif
