// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef POINTATTRIBUTES_H
#define POINTATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: PointAttributes
//
// Purpose:
//    Attributes for a point
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API PointAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    PointAttributes();
    PointAttributes(const PointAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    PointAttributes(private_tmfs_t tmfs);
    PointAttributes(const PointAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~PointAttributes();

    virtual PointAttributes& operator = (const PointAttributes &obj);
    virtual bool operator == (const PointAttributes &obj) const;
    virtual bool operator != (const PointAttributes &obj) const;
private:
    void Init();
    void Copy(const PointAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPoint();

    // Property setting methods
    void SetPoint(const double *point_);

    // Property getting methods
    const double *GetPoint() const;
          double *GetPoint();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_point = 0,
        ID__LAST
    };

private:
    double point[3];

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define POINTATTRIBUTES_TMFS "D"

#endif
